/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.eui;

import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.common.BadValue;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.StringInputRO;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.io.Serializable;
import java.util.ResourceBundle;

public class ATMAddressInputRO
extends Panel
implements JDMInput {
    protected Label networkLabel = new Label(ATMAddressInputRO.getNLSString("NetworkHeaderLabel"));
    protected StringInputRO networkValue = new StringInputRO("");
    protected Label systemLabel = new Label(ATMAddressInputRO.getNLSString("SystemIdentifierLabel"));
    protected StringInputRO systemValue = new StringInputRO("");
    protected Label selectorLabel = new Label(ATMAddressInputRO.getNLSString("SelectorByteLabel"));
    protected StringInputRO selectorValue = new StringInputRO("");
    private static ResourceBundle myResources = null;
    protected int maxlength = Integer.MAX_VALUE;

    public ATMAddressInputRO() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.networkLabel.setForeground(JmaColors.textText);
        this.systemLabel.setForeground(JmaColors.textText);
        this.selectorLabel.setForeground(JmaColors.textText);
        this.networkValue.setForeground(JmaColors.textText);
        this.systemValue.setForeground(JmaColors.textText);
        this.selectorValue.setForeground(JmaColors.textText);
        this.networkValue.setBackground(JmaColors.background);
        this.systemValue.setBackground(JmaColors.background);
        this.selectorValue.setBackground(JmaColors.background);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.networkLabel, gridBagConstraints);
        gridBagLayout.setConstraints(this.systemLabel, gridBagConstraints);
        gridBagLayout.setConstraints(this.selectorLabel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = -1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.gridheight = 1;
        gridBagLayout.setConstraints(this.networkValue, gridBagConstraints2);
        gridBagLayout.setConstraints(this.systemValue, gridBagConstraints2);
        gridBagLayout.setConstraints(this.selectorValue, gridBagConstraints2);
        this.add(this.networkLabel);
        this.add(this.networkValue);
        this.add(this.systemLabel);
        this.add(this.systemValue);
        this.add(this.selectorLabel);
        this.add(this.selectorValue);
    }

    public String stringValue() {
        return String.valueOf(this.networkValue.toString()) + this.systemValue.toString() + this.selectorValue.toString();
    }

    public Object getValue() {
        return new OctetString(this.stringValue());
    }

    public String toString() {
        return this.stringValue();
    }

    public void setValue(Object object) {
        Serializable serializable;
        if (object instanceof OctetString) {
            serializable = (OctetString)object;
            this.setValue(serializable.toString());
        }
        if (object instanceof SpecialValue) {
            serializable = (SpecialValue)object;
            this.setErrorValue((SpecialValue)serializable);
        }
    }

    public void setValue(String string) {
        if (string.length() == 40) {
            this.networkValue.setValue(string.substring(0, 26));
            this.systemValue.setValue(string.substring(26, 38));
            this.selectorValue.setValue(string.substring(38));
            return;
        }
        if (string.toString().equals("")) {
            this.networkValue.setValue("");
            this.systemValue.setValue("");
            this.selectorValue.setValue("");
            return;
        }
        this.setErrorValue(new BadValue());
    }

    public void setErrorValue(SpecialValue specialValue) {
        this.networkValue.setValue(specialValue);
        this.systemValue.setValue("");
        this.selectorValue.setValue("");
    }

    public boolean isValidValue() {
        return this.networkValue.isValidValue() && this.systemValue.isValidValue() && this.selectorValue.isValidValue();
    }

    public boolean ignoreValue() {
        return this.networkValue.ignoreValue();
    }

    protected static String getNLSString(String string) {
        try {
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.jdm.eui.ATMAddressInputResources");
            }
            if (myResources == null) {
                return string;
            }
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }
}

